/* FILE: mdsp.h                                 (J. Rogers      12/05/89)

This is an include file of defines, data structure definitions and
external declarations for the mdsp module.

*/

#ifndef _MDSP_
#define _MDSP_

/************************************************************************
                               INCLUDES

************************************************************************/
#include "mconst.h"


/************************************************************************
                                DEFINES
************************************************************************/
/* Enable Flags */
#define DSP_ENABLED             FALSE
#define CALIBRATION_ENABLED     FALSE
#define FFT_FILE_ENABLED        FALSE

#define NBANDS          16                      /* number fft bands */
#define CALTHR          45                      /* ratio for calib detect */
#define CAL_ABS_THR     450                    /* actual line values for cal */
#define NPTFFT          512                     /* FFT transform size */
#define NCHAN           8                      /* number of channels in fft */
#define BUF_SIZ         256                     /* pts in time buffer */
#define DSP_CALIBRATION             1     /* calibration type detection */
#define DSP_EVENT                   2     /* event type detect */
#define LOW_BAND_EDGE              10     /* lower band edge of interest */
#define HIGH_BAND_EDGE             50     /* upper band edge of interest */
#define STA_TIME                    2     /* number of buffers in avg */
#define LTA_TIME                   10      /* number of buffers in avg */
#define SPECTRAL_THR            999.4      /* ratio for trigger */
#define TIME_WINDOW                15      /* oldest age of valid trigger */
#define TRIGGERS_IN_WINDOW          3      /* minimun number trigs for evt */
#define DSP_EVENT_RECORDING_TIME   10      /* number buffers to record */

/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC FLAG dsp_calibration_detected ();
PUBLIC FLAG dsp_calibration_done ();
PUBLIC FLAG dsp_domain_chk ();
PUBLIC unsigned int dsp_get_calib_channel ();
PUBLIC char dsp_get_status ();
PUBLIC void dsp_initialize();
PUBLIC void dsp_set_MaxCalibrationTime (double);
PUBLIC void dsp_continue_band_recording ();
#endif
